"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logGlobalError = void 0;
const common_1 = require("@nestjs/common");
const logGlobalError = (logger, error) => {
    if (error instanceof common_1.HttpException) {
        const status = error.getStatus();
        const response = error.getResponse();
        logger.debug(`HttpException(${status}): ${JSON.stringify(response)}`);
        return;
    }
    if (error instanceof Error) {
        logger.error(`Unknown error: ${error}`, error?.stack);
        return;
    }
};
exports.logGlobalError = logGlobalError;
//# sourceMappingURL=logger.js.map