import { SystemConfigFFmpegDto } from 'src/dtos/system-config.dto';
import { TranscodeTarget, VideoCodec } from 'src/enum';
import { AudioStreamInfo, BitrateDistribution, TranscodeCommand, VideoCodecHWConfig, VideoCodecSWConfig, VideoFormat, VideoInterfaces, VideoStreamInfo } from 'src/types';
export declare class BaseConfig implements VideoCodecSWConfig {
    protected config: SystemConfigFFmpegDto;
    readonly presets: string[];
    protected constructor(config: SystemConfigFFmpegDto);
    static create(config: SystemConfigFFmpegDto, interfaces: VideoInterfaces): VideoCodecSWConfig;
    private static getSWCodecConfig;
    private static getHWCodecConfig;
    getCommand(target: TranscodeTarget, videoStream: VideoStreamInfo, audioStream?: AudioStreamInfo, format?: VideoFormat): TranscodeCommand;
    getBaseInputOptions(videoStream: VideoStreamInfo, format?: VideoFormat): string[];
    getBaseOutputOptions(target: TranscodeTarget, videoStream: VideoStreamInfo, audioStream?: AudioStreamInfo): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getInputThreadOptions(): Array<string>;
    getOutputThreadOptions(): Array<string>;
    eligibleForTwoPass(): boolean;
    getBitrateDistribution(): BitrateDistribution;
    getTargetResolution(videoStream: VideoStreamInfo): number;
    shouldScale(videoStream: VideoStreamInfo): boolean;
    shouldToneMap(videoStream: VideoStreamInfo): boolean;
    getScaling(videoStream: VideoStreamInfo, mult?: number): string;
    getSize(videoStream: VideoStreamInfo): {
        width: number;
        height: number;
    };
    isVideoRotated(videoStream: VideoStreamInfo): boolean;
    isVideoVertical(videoStream: VideoStreamInfo): boolean;
    isBitrateConstrained(): boolean;
    getBitrateUnit(): string;
    getMaxBitrateValue(): number;
    getPresetIndex(): number;
    getColors(): {
        primaries: string;
        transfer: string;
        matrix: string;
    };
    getToneMapping(videoStream: VideoStreamInfo): string[];
    getAudioCodec(): string;
    getVideoCodec(): string;
    getBFrames(): number;
    getRefs(): number;
    getGopSize(): number;
    useCQP(): boolean;
}
export declare class BaseHWConfig extends BaseConfig implements VideoCodecHWConfig {
    protected config: SystemConfigFFmpegDto;
    protected device: string;
    protected interfaces: VideoInterfaces;
    constructor(config: SystemConfigFFmpegDto, interfaces: VideoInterfaces);
    getSupportedCodecs(): VideoCodec[];
    validateDevices(devices: string[]): string[];
    getDevice({ dri }: VideoInterfaces): string;
    getVideoCodec(): string;
    getGopSize(): number;
}
export declare class ThumbnailConfig extends BaseConfig {
    static create(config: SystemConfigFFmpegDto): VideoCodecSWConfig;
    getBaseInputOptions(videoStream: VideoStreamInfo, format?: VideoFormat): string[];
    getBaseOutputOptions(): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getPresetOptions(): never[];
    getBitrateOptions(): never[];
    eligibleForTwoPass(): boolean;
    getScaling(videoStream: VideoStreamInfo): string;
}
export declare class H264Config extends BaseConfig {
    getOutputThreadOptions(): string[];
}
export declare class HEVCConfig extends BaseConfig {
    getOutputThreadOptions(): string[];
}
export declare class VP9Config extends BaseConfig {
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getOutputThreadOptions(): string[];
    eligibleForTwoPass(): boolean;
}
export declare class AV1Config extends BaseConfig {
    getVideoCodec(): string;
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getOutputThreadOptions(): never[];
    eligibleForTwoPass(): boolean;
}
export declare class NvencSwDecodeConfig extends BaseHWConfig {
    getDevice(): string;
    getSupportedCodecs(): VideoCodec[];
    getBaseInputOptions(): string[];
    getBaseOutputOptions(target: TranscodeTarget, videoStream: VideoStreamInfo, audioStream?: AudioStreamInfo): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getThreadOptions(): never[];
    getRefs(): number;
}
export declare class NvencHwDecodeConfig extends NvencSwDecodeConfig {
    getBaseInputOptions(): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getToneMapping(videoStream: VideoStreamInfo): string[];
    getInputThreadOptions(): string[];
    getOutputThreadOptions(): never[];
}
export declare class QsvSwDecodeConfig extends BaseHWConfig {
    getBaseInputOptions(): string[];
    getBaseOutputOptions(target: TranscodeTarget, videoStream: VideoStreamInfo, audioStream?: AudioStreamInfo): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getSupportedCodecs(): VideoCodec[];
    getBFrames(): number;
    getRefs(): number;
    useCQP(): boolean;
    getScaling(videoStream: VideoStreamInfo): string;
}
export declare class QsvHwDecodeConfig extends QsvSwDecodeConfig {
    getBaseInputOptions(): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getToneMapping(videoStream: VideoStreamInfo): string[];
    getInputThreadOptions(): string[];
}
export declare class VaapiSwDecodeConfig extends BaseHWConfig {
    getBaseInputOptions(): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getSupportedCodecs(): VideoCodec[];
    useCQP(): boolean;
}
export declare class VaapiHwDecodeConfig extends VaapiSwDecodeConfig {
    getBaseInputOptions(): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
    getToneMapping(videoStream: VideoStreamInfo): string[];
    getInputThreadOptions(): string[];
}
export declare class RkmppSwDecodeConfig extends BaseHWConfig {
    eligibleForTwoPass(): boolean;
    getBaseInputOptions(): string[];
    getPresetOptions(): string[];
    getBitrateOptions(): string[];
    getSupportedCodecs(): VideoCodec[];
    getVideoCodec(): string;
}
export declare class RkmppHwDecodeConfig extends RkmppSwDecodeConfig {
    getBaseInputOptions(): string[];
    getFilterOptions(videoStream: VideoStreamInfo): string[];
}
