/**
 * @param {number} pid process id. Required.
 * @param {Function} killFn optional kill function, defaults to process.kill
 * @returns boolean true if the given process id is in the local process
 * table. The PID may be paused or a zombie, though.
 */
export declare function pidExists(pid: number | undefined, killFn?: (pid: number, signal?: string | number) => boolean): boolean;
/**
 * Send a signal to the given process id.
 *
 * @param pid the process id. Required.
 * @param force if true, and the current user has
 * permissions to send the signal, the pid will be forced to shut down. Defaults to false.
 */
export declare function kill(pid: number | undefined, force?: boolean): boolean;
