"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.blank = blank;
exports.notBlank = notBlank;
exports.toNotBlank = toNotBlank;
exports.ensureSuffix = ensureSuffix;
exports.toS = toS;
function blank(s) {
    return s == null || toS(s).trim().length === 0;
}
function notBlank(s) {
    return !blank(s);
}
function toNotBlank(s) {
    const result = toS(s).trim();
    return result.length === 0 ? undefined : result;
}
function ensureSuffix(s, suffix) {
    return s.endsWith(suffix) ? s : s + suffix;
}
function toS(s) {
    /* eslint-disable-next-line @typescript-eslint/no-base-to-string */
    return s == null ? "" : s.toString();
}
//# sourceMappingURL=String.js.map