"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ClsRootModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsRootModule = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const cls_guard_1 = require("../cls-initializers/cls.guard");
const cls_interceptor_1 = require("../cls-initializers/cls.interceptor");
const cls_middleware_1 = require("../cls-initializers/cls.middleware");
const cls_internal_constants_1 = require("../cls.internal-constants");
const cls_options_1 = require("../cls.options");
const cls_plugin_manager_1 = require("../plugin/cls-plugin-manager");
const proxy_provider_manager_1 = require("../proxy-provider/proxy-provider-manager");
const cls_common_module_1 = require("./cls-common.module");
const middleware_utils_1 = require("./middleware.utils");
/**
 * This module contains logic for configuring the CLS module in the root.
 */
let ClsRootModule = ClsRootModule_1 = class ClsRootModule {
    constructor(adapterHost, moduleRef) {
        this.adapterHost = adapterHost;
        this.moduleRef = moduleRef;
    }
    configure(consumer) {
        const options = this.moduleRef.get(cls_internal_constants_1.CLS_MIDDLEWARE_OPTIONS);
        if (options.mount) {
            const adapter = this.adapterHost.httpAdapter;
            const mountPoint = (0, middleware_utils_1.getMiddlewareMountPoint)(adapter);
            ClsRootModule_1.logger.debug('Mounting ClsMiddleware to ' + mountPoint);
            consumer.apply(cls_middleware_1.ClsMiddleware).forRoutes(mountPoint);
        }
    }
    onModuleInit() {
        proxy_provider_manager_1.ProxyProviderManager.init();
    }
    /**
     * @internal
     * Called by ClsModule.forRoot.
     *
     */
    static forRoot(options) {
        options = { ...new cls_options_1.ClsModuleOptions(), ...options };
        const { providers, exports } = this.getProviders();
        proxy_provider_manager_1.ProxyProviderManager.reset(); // ensure that the proxy manager's state is clean
        const proxyProviders = this.createProxyClassProviders(options.proxyProviders);
        return {
            module: ClsRootModule_1,
            imports: cls_plugin_manager_1.ClsPluginManager.registerPlugins(options.plugins),
            providers: [
                {
                    provide: cls_internal_constants_1.CLS_MODULE_OPTIONS,
                    useValue: options,
                },
                ...providers,
                ...proxyProviders,
            ],
            exports: [...exports, ...proxyProviders.map((p) => p.provide)],
            global: false,
        };
    }
    /**
     * @internal
     * Called by ClsModule.forRootAsync.
     */
    static forRootAsync(asyncOptions) {
        const { providers, exports } = this.getProviders();
        proxy_provider_manager_1.ProxyProviderManager.reset(); // ensure that the proxy manager's state is clean
        const proxyProviders = this.createProxyClassProviders(asyncOptions.proxyProviders);
        return {
            module: ClsRootModule_1,
            imports: [
                ...(asyncOptions.imports ?? []),
                ...cls_plugin_manager_1.ClsPluginManager.registerPlugins(asyncOptions.plugins),
            ],
            providers: [
                {
                    provide: cls_internal_constants_1.CLS_MODULE_OPTIONS,
                    inject: asyncOptions.inject,
                    useFactory: asyncOptions.useFactory,
                },
                ...providers,
                ...proxyProviders,
            ],
            exports: [...exports, ...proxyProviders.map((p) => p.provide)],
            global: false,
        };
    }
    /**
     * @internal
     * Called by this modules's forRoot/Async abd ClsModule.forFeature
     */
    static createProxyClassProviders(proxyProviderClasses) {
        return (proxyProviderClasses?.map((providerClass) => proxy_provider_manager_1.ProxyProviderManager.createProxyProvider({
            useClass: providerClass,
        })) ?? []);
    }
    static getProviders() {
        const providers = [
            {
                provide: cls_internal_constants_1.CLS_MIDDLEWARE_OPTIONS,
                inject: [cls_internal_constants_1.CLS_MODULE_OPTIONS],
                useFactory: this.clsMiddlewareOptionsFactory,
            },
            {
                provide: cls_internal_constants_1.CLS_GUARD_OPTIONS,
                inject: [cls_internal_constants_1.CLS_MODULE_OPTIONS],
                useFactory: this.clsGuardOptionsFactory,
            },
            {
                provide: cls_internal_constants_1.CLS_INTERCEPTOR_OPTIONS,
                inject: [cls_internal_constants_1.CLS_MODULE_OPTIONS],
                useFactory: this.clsInterceptorOptionsFactory,
            },
        ];
        const enhancerArr = [
            {
                provide: core_1.APP_GUARD,
                inject: [cls_internal_constants_1.CLS_GUARD_OPTIONS],
                useFactory: this.clsGuardFactory,
            },
            {
                provide: core_1.APP_INTERCEPTOR,
                inject: [cls_internal_constants_1.CLS_INTERCEPTOR_OPTIONS],
                useFactory: this.clsInterceptorFactory,
            },
        ];
        return {
            providers: providers.concat(...enhancerArr),
            exports: providers,
        };
    }
    static clsMiddlewareOptionsFactory(options) {
        const clsMiddlewareOptions = {
            ...new cls_options_1.ClsMiddlewareOptions(),
            ...options.middleware,
        };
        return clsMiddlewareOptions;
    }
    static clsGuardOptionsFactory(options) {
        const clsGuardOptions = {
            ...new cls_options_1.ClsGuardOptions(),
            ...options.guard,
        };
        return clsGuardOptions;
    }
    static clsInterceptorOptionsFactory(options) {
        const clsInterceptorOptions = {
            ...new cls_options_1.ClsInterceptorOptions(),
            ...options.interceptor,
        };
        return clsInterceptorOptions;
    }
    static clsGuardFactory(options) {
        if (options.mount) {
            ClsRootModule_1.logger.debug('ClsGuard will be automatically mounted');
            return new cls_guard_1.ClsGuard(options);
        }
        return {
            canActivate: () => true,
        };
    }
    static clsInterceptorFactory(options) {
        if (options.mount) {
            ClsRootModule_1.logger.debug('ClsInterceptor will be automatically mounted');
            return new cls_interceptor_1.ClsInterceptor(options);
        }
        return {
            intercept: (_, next) => next.handle(),
        };
    }
};
exports.ClsRootModule = ClsRootModule;
ClsRootModule.logger = new common_1.Logger('ClsModule');
exports.ClsRootModule = ClsRootModule = ClsRootModule_1 = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [cls_common_module_1.ClsCommonModule],
    }),
    __metadata("design:paramtypes", [core_1.HttpAdapterHost,
        core_1.ModuleRef])
], ClsRootModule);
//# sourceMappingURL=cls-root.module.js.map