"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reflectClassConstructorParams = reflectClassConstructorParams;
exports.reflectAllClassDependencies = reflectAllClassDependencies;
const injector_1 = require("@nestjs/core/injector/injector");
const injector = new injector_1.Injector();
function reflectClassConstructorParams(Class) {
    return injector.reflectConstructorParams(Class);
}
function reflectAllClassDependencies(Class) {
    const constructorParams = reflectClassConstructorParams(Class);
    const properties = injector
        .reflectProperties(Class)
        .map((prop) => prop.name);
    return [...constructorParams, ...properties];
}
//# sourceMappingURL=proxy-provider.utils.js.map